<?php

use App\core\Logger;
use App\services\PaymentService;
use App\services\WebhookHandler;
use PHPUnit\Framework\TestCase;

class WebhookHandlerTest extends TestCase
{
    public function testInvalidSignatureReturnsError(): void
    {
        $db = $this->createMock(PDO::class);
        $logger = $this->createMock(Logger::class);
        $payment = $this->getMockBuilder(PaymentService::class)
            ->disableOriginalConstructor()
            ->onlyMethods(['validateSignature'])
            ->getMock();
        $payment->method('validateSignature')->willReturn(false);
        $handler = new WebhookHandler($db, $payment, $logger);
        $result = $handler->handle(['foo' => 'bar'], 'bad');
        $this->assertSame(['error' => 'invalid_signature'], $result);
    }
}

