<?php

use App\core\Encryptor;
use App\core\Logger;
use App\services\ExcelImporter;
use PHPUnit\Framework\TestCase;

class ExcelImporterTest extends TestCase
{
    public function testMapRowReturnsData(): void
    {
        $db = $this->createMock(PDO::class);
        $encryptor = $this->createMock(Encryptor::class);
        $logger = $this->createMock(Logger::class);
        $importer = new ExcelImporter($db, $encryptor, $logger);
        $ref = new ReflectionClass($importer);
        $method = $ref->getMethod('mapRow');
        $method->setAccessible(true);
        $row = ['A' => 'acc', 'B' => 'pass'];
        $mapping = ['A' => 'account', 'B' => 'password'];
        $result = $method->invoke($importer, $row, $mapping);
        $this->assertSame(['account' => 'acc', 'password' => 'pass'], $result);
    }
}

