<?php

use App\core\Encryptor;
use PHPUnit\Framework\TestCase;

class EncryptorTest extends TestCase
{
    public function testEncryptDecryptRoundTrip(): void
    {
        $encryptor = new Encryptor('test_master_key_32bytes_string_for_demo');
        $payload = ['account' => 'user', 'password' => 'pass'];
        $blob = $encryptor->encrypt($payload, 1);
        $result = $encryptor->decrypt($blob, 1);
        $this->assertSame($payload, $result);
    }

    public function testTamperedTagFails(): void
    {
        $this->expectException(RuntimeException::class);
        $encryptor = new Encryptor('test_master_key_32bytes_string_for_demo');
        $payload = ['account' => 'user'];
        $blob = $encryptor->encrypt($payload, 2);
        $blob['tag'] = base64_encode(strrev(base64_decode($blob['tag'])));
        $encryptor->decrypt($blob, 2);
    }
}

