<?php

use App\controllers\AuthController;
use App\controllers\EngagementController;
use App\controllers\TicketController;
use App\controllers\OrderController;
use App\controllers\PublicController;
use App\controllers\WebhookController;
use App\core\Auth;
use App\core\Encryptor;
use App\core\Logger;
use App\core\RateLimiter;
use App\core\Router;
use App\services\AffiliateService;
use App\services\CartService;
use App\services\DeliveryService;
use App\services\DiscountService;
use App\services\FraudService;
use App\services\NotificationService;
use App\services\OrderService;
use App\services\WebhookHandler;
use App\services\PaymentService;

// #region agent log
file_put_contents(
    'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
    json_encode([
        'sessionId' => 'debug-session',
        'runId' => 'run3',
        'hypothesisId' => 'H4',
        'location' => 'public_html/index.php:pre_autoload',
        'message' => 'Entry reached before autoload',
        'data' => [
            'requestMethod' => $_SERVER['REQUEST_METHOD'] ?? null,
            'requestUri' => $_SERVER['REQUEST_URI'] ?? null,
            'cwd' => getcwd(),
            'scriptFilename' => $_SERVER['SCRIPT_FILENAME'] ?? null,
        ],
        'timestamp' => round(microtime(true) * 1000),
    ]) . PHP_EOL,
    FILE_APPEND
);
// #endregion

$autoloadPath = __DIR__ . '/../vendor/autoload.php';
// #region agent log
file_put_contents(
    'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
    json_encode([
        'sessionId' => 'debug-session',
        'runId' => 'run3',
        'hypothesisId' => 'H5',
        'location' => 'public_html/index.php:autoload_check',
        'message' => 'Checking vendor autoload presence',
        'data' => ['exists' => file_exists($autoloadPath), 'path' => $autoloadPath],
        'timestamp' => round(microtime(true) * 1000),
    ]) . PHP_EOL,
    FILE_APPEND
);
// #endregion

require $autoloadPath;

// #region agent log
file_put_contents(
    'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
    json_encode([
        'sessionId' => 'debug-session',
        'runId' => 'run3',
        'hypothesisId' => 'H4',
        'location' => 'public_html/index.php:start',
        'message' => 'Entry reached',
        'data' => ['requestMethod' => $_SERVER['REQUEST_METHOD'] ?? null, 'requestUri' => $_SERVER['REQUEST_URI'] ?? null],
        'timestamp' => round(microtime(true) * 1000),
    ]) . PHP_EOL,
    FILE_APPEND
);
// #endregion

// Load env
if (file_exists(__DIR__ . '/../env.example') && file_exists(__DIR__ . '/../.env') === false) {
    // allow loading from env.example during demo
    $dotenv = Dotenv\Dotenv::createImmutable(dirname(__DIR__), 'env.example');
} else {
    $dotenv = Dotenv\Dotenv::createImmutable(dirname(__DIR__));
}
$dotenv->safeLoad();

$dbConfig = require dirname(__DIR__) . '/app/config/database.php';
$appConfig = require dirname(__DIR__) . '/app/config/app.php';
$secrets = require dirname(__DIR__) . '/app/config/secrets.php';

try {
    $pdo = new PDO($dbConfig['dsn'], $dbConfig['user'], $dbConfig['password'], $dbConfig['options']);
    // #region agent log
    file_put_contents(
        'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
        json_encode([
            'sessionId' => 'debug-session',
            'runId' => 'run3',
            'hypothesisId' => 'H1',
            'location' => 'public_html/index.php:pdo',
            'message' => 'PDO connection established',
            'data' => ['dsn' => $dbConfig['dsn']],
            'timestamp' => round(microtime(true) * 1000),
        ]) . PHP_EOL,
        FILE_APPEND
    );
    // #endregion
} catch (\Throwable $e) {
    // #region agent log
    file_put_contents(
        'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
        json_encode([
            'sessionId' => 'debug-session',
            'runId' => 'run3',
            'hypothesisId' => 'H1',
            'location' => 'public_html/index.php:pdo_error',
            'message' => 'PDO connection failed',
            'data' => ['error' => $e->getMessage()],
            'timestamp' => round(microtime(true) * 1000),
        ]) . PHP_EOL,
        FILE_APPEND
    );
    // #endregion
    throw $e;
}

$router = new Router();
$auth = new Auth($pdo);
$rateLimiter = new RateLimiter($appConfig['rate_limit']['max'], $appConfig['rate_limit']['window']);
$logger = new Logger($pdo);
$encryptor = new Encryptor($secrets['master_key']);
$notifier = new NotificationService($appConfig['telegram']['token'], $appConfig['telegram']['chat_id']);
$affiliateService = new AffiliateService($pdo, $logger);
$deliveryService = new DeliveryService($pdo, $encryptor, $logger, $notifier, $affiliateService);
$fraudService = new FraudService($pdo, $logger);
$paymentService = new PaymentService($pdo, $logger, $secrets['payment_provider'], $secrets['payment_secret']);
$paymentService->withDelivery($deliveryService, $fraudService, $notifier);
$webhookHandler = new WebhookHandler($pdo, $paymentService, $logger);
$cart = new CartService();
$discountService = new DiscountService($pdo);
$orderService = new OrderService($pdo, $discountService, $logger);

$public = new PublicController($pdo);
$authController = new AuthController($pdo, $auth, $rateLimiter);
$orderController = new OrderController($pdo, $auth, $cart, $orderService, $paymentService, $deliveryService, $encryptor);
$engagementController = new EngagementController($pdo, $auth);
$ticketController = new TicketController($pdo, $auth);
$webhookController = new WebhookController($webhookHandler);

$router->add('GET', '/', [$public, 'home']);
$router->add('GET', '/products', [$public, 'list']);
$router->add('GET', '/product/{id}', [$public, 'show']);

$router->add('POST', '/auth/register', [$authController, 'register']);
$router->add('POST', '/auth/login', [$authController, 'login']);

$router->add('POST', '/cart/add', [$orderController, 'addToCart']);
$router->add('GET', '/cart', [$orderController, 'viewCart']);
$router->add('POST', '/cart/checkout', [$orderController, 'checkout']);
$router->add('POST', '/checkout/pay', [$orderController, 'pay']);
$router->add('GET', '/user/orders', [$orderController, 'listOrders']);
$router->add('GET', '/user/order/{id}', [$orderController, 'showOrder']);
$router->add('POST', '/product/{id}/review', [$engagementController, 'review']);
$router->add('POST', '/lucky-spin', [$engagementController, 'luckySpin']);
$router->add('GET', '/tickets', [$ticketController, 'list']);
$router->add('POST', '/tickets', [$ticketController, 'create']);

$router->add('GET', '/health', function () {
    echo json_encode(['status' => 'ok']);
});

$router->add('POST', '/webhook/payment', [$webhookController, 'payment']);

$requestPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
// #region agent log
file_put_contents(
    'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
    json_encode([
        'sessionId' => 'debug-session',
        'runId' => 'run3',
        'hypothesisId' => 'H2',
        'location' => 'public_html/index.php:dispatch',
        'message' => 'Dispatching request',
        'data' => ['method' => $_SERVER['REQUEST_METHOD'] ?? '', 'path' => $requestPath],
        'timestamp' => round(microtime(true) * 1000),
    ]) . PHP_EOL,
    FILE_APPEND
);
// #endregion

$router->dispatch($_SERVER['REQUEST_METHOD'], parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

