# API Overview

## Auth
- `POST /auth/register` {email, password}
- `POST /auth/login` {email, password}

## Public
- `GET /` danh sách hot/new
- `GET /products` danh sách + filter (future params: q, category, page)
- `GET /product/{id}` chi tiết
- `POST /cart/add` (session) — thêm item
- `GET /cart` / `POST /cart/checkout` tạo order pending (discount_code, affiliate_id optional)
- `POST /checkout/pay` chọn phương thức + PIN (nếu dùng balance) hoặc gateway
- `GET /user/orders`, `GET /user/order/{id}` (trả về deliveries giải mã cho user)
- `POST /product/{id}/review` đánh giá 1-5*
- `POST /lucky-spin` quay thưởng (demo, thưởng vào balance)
- `GET /tickets`, `POST /tickets` tạo/list ticket hỗ trợ
- `GET /health` healthcheck

## Webhook
- `POST /webhook/payment`
  - Header: `X-Signature: hmac_sha256(body, PAYMENT_SECRET)`
  - Payload: `{transaction_id, amount, reference_id, reference_type: order|recharge, status}`
  - Response: `{status: ok}` hoặc `{error}`
  - Idempotency: bỏ qua nếu tx_id đã tồn tại.

## Admin (auth + PIN cho hành động nhạy cảm)
- `GET /admin/dashboard`
- `GET /admin/orders`, `POST /admin/order/{id}/approve|cancel`
- `POST /admin/products`, `PUT /admin/product/{id}` (placeholder)
- `POST /admin/product/{id}/upload-variants` (Excel upload + mapping JSON)
- `POST /admin/variant/{id}/decrypt` {pin}
- `GET /admin/transactions`, `POST /admin/recharge/{id}/approve`
- `GET /admin/logs`
- `GET /admin/users`, `POST /admin/user/{id}/adjust-balance` {pin, delta}
- `GET /admin/settings`, `PUT /admin/settings`

## Response mẫu
- Success: `{"status":"ok","data":{...}}`
- Error: HTTP phù hợp + `{"error":"message"}`

## Notes bảo mật
- Tất cả query dùng prepared statement (PDO).
- PIN xác minh trước khi giải mã/ghi nhạy cảm.
- Rate limit IP trong Auth.
- Audit log ghi action, actor, payload rút gọn.

