# Deployment Guide

## Docker Compose (php-fpm + nginx + mysql + redis)
```yaml
version: "3.9"
services:
  app:
    image: php:8.2-fpm
    working_dir: /var/www
    volumes:
      - ./:/var/www
    environment:
      APP_ENV: production
      APP_DEBUG: "false"
      MASTER_KEY: ${MASTER_KEY}
      DB_HOST: db
      DB_PORT: 3306
      DB_NAME: assetdb
      DB_USER: asset
      DB_PASSWORD: ${DB_PASSWORD}
      PAYMENT_SECRET: ${PAYMENT_SECRET}
    depends_on:
      - db
  web:
    image: nginx:1.25
    volumes:
      - ./:/var/www
      - ./docker/nginx.conf:/etc/nginx/conf.d/default.conf
    ports:
      - "8080:80"
    depends_on:
      - app
  db:
    image: mysql:8
    restart: always
    environment:
      MYSQL_DATABASE: assetdb
      MYSQL_USER: asset
      MYSQL_PASSWORD: ${DB_PASSWORD}
      MYSQL_ROOT_PASSWORD: ${DB_ROOT_PASSWORD}
    ports:
      - "3307:3306"
    volumes:
      - dbdata:/var/lib/mysql
  redis:
    image: redis:7
volumes:
  dbdata:
```

## Nginx snippet
```
location / {
    root /var/www/public_html;
    index index.php;
    try_files $uri /index.php?$query_string;
}
location /admin {
    alias /var/www/admin;
    try_files $uri /admin/index.php?$query_string;
}
location ~ \.php$ {
    fastcgi_pass app:9000;
    include fastcgi_params;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
}
```

## Steps
- `composer install --no-dev`
- `php -d detect_unicode=0 -r "copy('env.example','.env');"` và set secrets.
- `mysql < app/migrations/schema.sql`
- Set `MASTER_KEY` an toàn; bật HTTPS, HTTP security headers.
- Thiết lập cron/worker cho queue (nếu bật import lớn).
- Backup DB hằng ngày; tách backup bảng nhạy cảm và mã hóa ngoài.
- Thiết lập giám sát: healthcheck `/health` (add route) và error log (Sentry optional).

