<?php

namespace App\services;

use GuzzleHttp\Client;

class NotificationService
{
    private Client $client;
    private string $telegramToken;
    private string $telegramChatId;

    public function __construct(string $telegramToken, string $telegramChatId)
    {
        $this->client = new Client(['timeout' => 5]);
        $this->telegramToken = $telegramToken;
        $this->telegramChatId = $telegramChatId;
    }

    public function notifyTelegram(string $message): void
    {
        if (!$this->telegramToken || !$this->telegramChatId) {
            return;
        }
        $this->client->post("https://api.telegram.org/bot{$this->telegramToken}/sendMessage", [
            'json' => [
                'chat_id' => $this->telegramChatId,
                'text' => $message,
                'parse_mode' => 'Markdown',
            ],
        ]);
    }
}

