<?php

namespace App\services;

use App\core\Logger;
use PDO;

class FraudService
{
    private PDO $db;
    private Logger $logger;

    public function __construct(PDO $db, Logger $logger)
    {
        $this->db = $db;
        $this->logger = $logger;
    }

    public function checkOrderPayment(int $orderId, float $amount, string $txId, string $ip = ''): bool
    {
        $stmt = $this->db->prepare('SELECT total, status FROM orders WHERE id = :id');
        $stmt->execute(['id' => $orderId]);
        $order = $stmt->fetch();
        if (!$order) {
            return false;
        }
        if ($order['status'] !== 'pending') {
            return false;
        }
        $duplicate = $this->db->prepare('SELECT id FROM transactions WHERE meta->>"$.tx_id" = :tx LIMIT 1');
        $duplicate->execute(['tx' => $txId]);
        if ($duplicate->fetch()) {
            return false;
        }
        $delta = abs((float) $order['total'] - $amount);
        $ok = $delta < 0.01;
        if (!$ok) {
            $this->logger->audit(null, 'fraud_amount_mismatch', 'orders', $orderId, ['expected' => $order['total'], 'got' => $amount, 'ip' => $ip]);
        }
        return $ok;
    }
}

