<?php

namespace App\services;

use PDO;

class DiscountService
{
    private PDO $db;

    public function __construct(PDO $db)
    {
        $this->db = $db;
    }

    public function apply(?string $code, float $subtotal, int $userId): array
    {
        if (!$code) {
            return ['discount' => 0.0, 'code' => null];
        }
        $stmt = $this->db->prepare('SELECT * FROM discount_codes WHERE code = :code');
        $stmt->execute(['code' => $code]);
        $row = $stmt->fetch();
        if (!$row) {
            return ['discount' => 0.0, 'code' => null];
        }
        $now = new \DateTime();
        if (($row['start_at'] && $now < new \DateTime($row['start_at'])) ||
            ($row['end_at'] && $now > new \DateTime($row['end_at']))) {
            return ['discount' => 0.0, 'code' => null];
        }
        if ($row['min_order'] && $subtotal < (float) $row['min_order']) {
            return ['discount' => 0.0, 'code' => null];
        }
        // TODO: enforce usage_limit/per_user_limit with a usage table
        $discount = $row['type'] === 'percent'
            ? round($subtotal * ((float) $row['value'] / 100), 2)
            : (float) $row['value'];
        $discount = min($discount, $subtotal);
        return ['discount' => $discount, 'code' => $row['code']];
    }
}

