<?php

namespace App\services;

class CartService
{
    public function __construct()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        if (!isset($_SESSION['cart'])) {
            $_SESSION['cart'] = [];
        }
    }

    public function add(int $productId, int $qty = 1): void
    {
        $qty = max(1, $qty);
        if (isset($_SESSION['cart'][$productId])) {
            $_SESSION['cart'][$productId] += $qty;
        } else {
            $_SESSION['cart'][$productId] = $qty;
        }
    }

    public function items(): array
    {
        return $_SESSION['cart'];
    }

    public function clear(): void
    {
        $_SESSION['cart'] = [];
    }
}

