<?php

namespace App\services;

use App\core\Logger;
use PDO;

class AffiliateService
{
    private PDO $db;
    private Logger $logger;

    public function __construct(PDO $db, Logger $logger)
    {
        $this->db = $db;
        $this->logger = $logger;
    }

    public function trackReferral(int $referrerId, int $userId, float $commissionPercent): void
    {
        $stmt = $this->db->prepare(
            'INSERT INTO affiliates (referrer_user_id, referred_user_id, commission_percent, created_at)
             VALUES (:referrer_user_id, :referred_user_id, :commission_percent, NOW())'
        );
        $stmt->execute([
            'referrer_user_id' => $referrerId,
            'referred_user_id' => $userId,
            'commission_percent' => $commissionPercent,
        ]);
        $this->logger->audit($referrerId, 'affiliate_track', 'affiliates', (int) $this->db->lastInsertId(), []);
    }

    public function recordBonus(int $referrerId, int $orderId, float $amount): void
    {
        $this->db->prepare(
            'INSERT INTO transactions (user_id, type, amount, meta, created_at) VALUES (:user_id, :type, :amount, :meta, NOW())'
        )->execute([
            'user_id' => $referrerId,
            'type' => 'affiliate_bonus',
            'amount' => $amount,
            'meta' => json_encode(['order_id' => $orderId]),
        ]);
        $this->db->prepare('UPDATE users SET balance = balance + :amount WHERE id = :id')
            ->execute(['amount' => $amount, 'id' => $referrerId]);
        $this->logger->audit($referrerId, 'affiliate_bonus', 'transactions', (int) $this->db->lastInsertId(), []);
    }
}

