<?php

namespace App\core;

class Router
{
    private array $routes = [];
    private array $middleware = [];

    public function add(string $method, string $pattern, callable $handler): void
    {
        $this->routes[] = [
            'method' => strtoupper($method),
            'pattern' => '#^' . preg_replace('#\{(\w+)\}#', '(?P<$1>[^/]+)', $pattern) . '$#',
            'handler' => $handler,
        ];
    }

    public function dispatch(string $method, string $path)
    {
        foreach ($this->routes as $route) {
            if ($route['method'] !== strtoupper($method)) {
                continue;
            }
            if (preg_match($route['pattern'], $path, $matches)) {
                $params = array_filter($matches, 'is_string', ARRAY_FILTER_USE_KEY);
                // #region agent log
                file_put_contents(
                    'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
                    json_encode([
                        'sessionId' => 'debug-session',
                        'runId' => 'run3',
                        'hypothesisId' => 'H2',
                        'location' => 'app/core/Router.php:match',
                        'message' => 'Route matched',
                        'data' => ['method' => $method, 'path' => $path, 'pattern' => $route['pattern'], 'params' => $params],
                        'timestamp' => round(microtime(true) * 1000),
                    ]) . PHP_EOL,
                    FILE_APPEND
                );
                // #endregion
                return call_user_func($route['handler'], $params);
            }
        }
        // #region agent log
        file_put_contents(
            'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
            json_encode([
                'sessionId' => 'debug-session',
                'runId' => 'run3',
                'hypothesisId' => 'H3',
                'location' => 'app/core/Router.php:not_found',
                'message' => 'Route not found',
                'data' => ['method' => $method, 'path' => $path],
                'timestamp' => round(microtime(true) * 1000),
            ]) . PHP_EOL,
            FILE_APPEND
        );
        // #endregion
        http_response_code(404);
        echo json_encode(['error' => 'Not found']);
        return null;
    }
}

