<?php

namespace App\core;

class RateLimiter
{
    private int $maxAttempts;
    private int $window;
    private string $prefix;

    public function __construct(int $maxAttempts = 10, int $window = 60, string $prefix = 'rl_')
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        $this->maxAttempts = $maxAttempts;
        $this->window = $window;
        $this->prefix = $prefix;
    }

    public function tooManyAttempts(string $key): bool
    {
        $bucket = $this->bucketKey($key);
        $now = time();
        if (!isset($_SESSION[$bucket])) {
            $_SESSION[$bucket] = ['count' => 0, 'reset' => $now + $this->window];
        }
        $bucketData = &$_SESSION[$bucket];
        if ($now > $bucketData['reset']) {
            $bucketData = ['count' => 0, 'reset' => $now + $this->window];
        }
        if ($bucketData['count'] >= $this->maxAttempts) {
            return true;
        }
        $bucketData['count']++;
        return false;
    }

    private function bucketKey(string $key): string
    {
        return $this->prefix . md5($key);
    }
}

