<?php

namespace App\core;

use PDO;

class Logger
{
    private PDO $db;

    public function __construct(PDO $db)
    {
        $this->db = $db;
    }

    public function audit(?int $actorId, string $action, string $table, ?int $recordId, array $payload = []): void
    {
        $stmt = $this->db->prepare(
            'INSERT INTO logs_audit (actor_id, action, table_name, record_id, ip, user_agent, payload, created_at) 
             VALUES (:actor_id, :action, :table_name, :record_id, :ip, :user_agent, :payload, NOW())'
        );
        $stmt->execute([
            'actor_id' => $actorId,
            'action' => $action,
            'table_name' => $table,
            'record_id' => $recordId,
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'cli',
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'cli',
            'payload' => json_encode($payload),
        ]);
    }
}

