<?php

namespace App\controllers;

use App\core\Controller;
use App\services\WebhookHandler;

class WebhookController extends Controller
{
    private WebhookHandler $handler;

    public function __construct(WebhookHandler $handler)
    {
        $this->handler = $handler;
    }

    public function payment(): void
    {
        $payload = json_decode(file_get_contents('php://input'), true) ?? [];
        $signature = $_SERVER['HTTP_X_SIGNATURE'] ?? '';
        $result = $this->handler->handle($payload, $signature);
        $this->json($result);
    }
}

