<?php

namespace App\controllers;

use App\core\Auth;
use App\core\Controller;
use PDO;

class TicketController extends Controller
{
    private PDO $db;
    private Auth $auth;

    public function __construct(PDO $db, Auth $auth)
    {
        $this->db = $db;
        $this->auth = $auth;
    }

    public function create(): void
    {
        $this->auth->requireUser();
        $payload = json_decode(file_get_contents('php://input'), true) ?? [];
        $stmt = $this->db->prepare(
            'INSERT INTO tickets (user_id, subject, content, status, created_at) VALUES (:user_id, :subject, :content, "open", NOW())'
        );
        $stmt->execute([
            'user_id' => $this->auth->user()['id'],
            'subject' => $payload['subject'] ?? '',
            'content' => $payload['content'] ?? '',
        ]);
        $this->json(['status' => 'ok']);
    }

    public function list(): void
    {
        $this->auth->requireUser();
        $stmt = $this->db->prepare('SELECT * FROM tickets WHERE user_id = :uid ORDER BY created_at DESC');
        $stmt->execute(['uid' => $this->auth->user()['id']]);
        $this->json(['tickets' => $stmt->fetchAll()]);
    }
}

