<?php

namespace App\controllers;

use App\core\Controller;
use PDO;

class PublicController extends Controller
{
    private PDO $db;

    public function __construct(PDO $db)
    {
        $this->db = $db;
    }

    public function home(): void
    {
        $stmt = $this->db->query('SELECT id, title, price, is_hot FROM products ORDER BY created_at DESC LIMIT 10');
        $this->json(['products' => $stmt->fetchAll()]);
    }

    public function list(): void
    {
        $stmt = $this->db->query('SELECT id, title, price, is_hot FROM products ORDER BY created_at DESC');
        $this->json(['products' => $stmt->fetchAll()]);
    }

    public function show(array $params): void
    {
        $stmt = $this->db->prepare('SELECT * FROM products WHERE id = :id');
        $stmt->execute(['id' => $params['id'] ?? 0]);
        $product = $stmt->fetch();
        if (!$product) {
            $this->json(['error' => 'Product not found'], 404);
            return;
        }
        $this->json(['product' => $product]);
    }
}

