<?php

namespace App\controllers;

use App\core\Auth;
use App\core\Controller;
use PDO;

class EngagementController extends Controller
{
    private PDO $db;
    private Auth $auth;

    public function __construct(PDO $db, Auth $auth)
    {
        $this->db = $db;
        $this->auth = $auth;
    }

    public function review(array $params): void
    {
        $this->auth->requireUser();
        $payload = json_decode(file_get_contents('php://input'), true) ?? [];
        $rating = max(1, min(5, (int) ($payload['rating'] ?? 0)));
        $comment = $payload['comment'] ?? '';
        $stmt = $this->db->prepare(
            'INSERT INTO product_reviews (user_id, product_id, rating, comment, created_at) VALUES (:user_id, :product_id, :rating, :comment, NOW())'
        );
        $stmt->execute([
            'user_id' => $this->auth->user()['id'],
            'product_id' => (int) ($params['id'] ?? 0),
            'rating' => $rating,
            'comment' => $comment,
        ]);
        $this->json(['status' => 'ok']);
    }

    public function luckySpin(): void
    {
        $this->auth->requireUser();
        $reward = rand(0, 100) > 80 ? 1.0 : 0.0;
        $this->db->prepare(
            'INSERT INTO lucky_spins (user_id, reward_amount, reward_meta, created_at) VALUES (:user_id, :reward_amount, :reward_meta, NOW())'
        )->execute([
            'user_id' => $this->auth->user()['id'],
            'reward_amount' => $reward,
            'reward_meta' => json_encode(['source' => 'daily_spin']),
        ]);
        if ($reward > 0) {
            $this->db->prepare('UPDATE users SET balance = balance + :reward WHERE id = :id')
                ->execute(['reward' => $reward, 'id' => $this->auth->user()['id']]);
        }
        $this->json(['status' => 'ok', 'reward' => $reward]);
    }
}

