<?php

namespace App\controllers;

use App\core\Auth;
use App\core\Controller;
use App\core\RateLimiter;
use PDO;

class AuthController extends Controller
{
    private PDO $db;
    private Auth $auth;
    private RateLimiter $rateLimiter;

    public function __construct(PDO $db, Auth $auth, RateLimiter $rateLimiter)
    {
        $this->db = $db;
        $this->auth = $auth;
        $this->rateLimiter = $rateLimiter;
    }

    public function register(): void
    {
        $payload = json_decode(file_get_contents('php://input'), true);
        if ($this->rateLimiter->tooManyAttempts($_SERVER['REMOTE_ADDR'] ?? 'ip')) {
            $this->json(['error' => 'Too many attempts'], 429);
            return;
        }
        $stmt = $this->db->prepare('INSERT INTO users (email, password_hash, role, balance, created_at) VALUES (:email, :password_hash, :role, 0, NOW())');
        $stmt->execute([
            'email' => $payload['email'],
            'password_hash' => password_hash($payload['password'], PASSWORD_DEFAULT),
            'role' => 'user',
        ]);
        $this->json(['status' => 'registered']);
    }

    public function login(): void
    {
        $payload = json_decode(file_get_contents('php://input'), true);
        if ($this->rateLimiter->tooManyAttempts($_SERVER['REMOTE_ADDR'] ?? 'ip')) {
            $this->json(['error' => 'Too many attempts'], 429);
            return;
        }
        $ok = $this->auth->attempt($payload['email'], $payload['password']);
        if (!$ok) {
            $this->json(['error' => 'Invalid credentials'], 401);
            return;
        }
        $this->json(['status' => 'ok']);
    }
}

