<?php

return [
    'env' => getenv('APP_ENV') ?: 'local',
    'debug' => filter_var(getenv('APP_DEBUG'), FILTER_VALIDATE_BOOLEAN),
    'url' => getenv('APP_URL') ?: 'http://localhost',
    'rate_limit' => [
        'max' => (int) (getenv('RATE_LIMIT_MAX') ?: 10),
        'window' => (int) (getenv('RATE_LIMIT_WINDOW') ?: 60),
    ],
    'telegram' => [
        'token' => getenv('TELEGRAM_TOKEN') ?: '',
        'chat_id' => getenv('TELEGRAM_CHAT_ID') ?: '',
    ],
];

