<?php

use App\controllers\AdminController;
use App\core\Auth;
use App\core\Encryptor;
use App\core\Logger;
use App\core\RateLimiter;
use App\core\Router;
use App\services\ExcelImporter;
use App\services\NotificationService;

require __DIR__ . '/../vendor/autoload.php';

$autoloadPath = __DIR__ . '/../vendor/autoload.php';
// #region agent log
file_put_contents(
    'c:\\xampp\\htdocs\\lor\\.cursor\\debug.log',
    json_encode([
        'sessionId' => 'debug-session',
        'runId' => 'run3',
        'hypothesisId' => 'H6',
        'location' => 'admin/index.php:pre_autoload',
        'message' => 'Admin entry reached before autoload',
        'data' => [
            'requestMethod' => $_SERVER['REQUEST_METHOD'] ?? null,
            'requestUri' => $_SERVER['REQUEST_URI'] ?? null,
            'cwd' => getcwd(),
            'scriptFilename' => $_SERVER['SCRIPT_FILENAME'] ?? null,
            'autoloadExists' => file_exists($autoloadPath),
        ],
        'timestamp' => round(microtime(true) * 1000),
    ]) . PHP_EOL,
    FILE_APPEND
);
// #endregion

$dotenv = Dotenv\Dotenv::createImmutable(dirname(__DIR__));
$dotenv->safeLoad();

$dbConfig = require dirname(__DIR__) . '/app/config/database.php';
$appConfig = require dirname(__DIR__) . '/app/config/app.php';
$secrets = require dirname(__DIR__) . '/app/config/secrets.php';
$pdo = new PDO($dbConfig['dsn'], $dbConfig['user'], $dbConfig['password'], $dbConfig['options']);

$router = new Router();
$auth = new Auth($pdo);
$rateLimiter = new RateLimiter();
$logger = new Logger($pdo);
$encryptor = new Encryptor($secrets['master_key']);
$importer = new ExcelImporter($pdo, $encryptor, $logger);
$notifier = new NotificationService($appConfig['telegram']['token'], $appConfig['telegram']['chat_id']);

$admin = new AdminController($pdo, $auth, $encryptor, $logger, $importer, $notifier);

$router->add('GET', '/admin/dashboard', [$admin, 'dashboard']);
$router->add('POST', '/admin/variant/{id}/decrypt', [$admin, 'decryptVariant']);
$router->add('GET', '/admin/orders', [$admin, 'orders']);
$router->add('POST', '/admin/order/{id}/approve', [$admin, 'approveOrder']);
$router->add('POST', '/admin/order/{id}/cancel', [$admin, 'cancelOrder']);
$router->add('POST', '/admin/product/{id}/upload-variants', [$admin, 'uploadVariants']);
$router->add('GET', '/admin/transactions', [$admin, 'transactions']);
$router->add('POST', '/admin/user/{id}/adjust-balance', [$admin, 'adjustBalance']);
$router->add('GET', '/admin/settings', [$admin, 'settings']);
$router->add('PUT', '/admin/settings', [$admin, 'updateSettings']);
$router->add('GET', '/admin/logs', [$admin, 'logs']);
$router->add('GET', '/admin/users', [$admin, 'users']);

$router->dispatch($_SERVER['REQUEST_METHOD'], parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

