# Digital Asset Platform (PHP + MySQL)

Nền tảng bán tài nguyên số tự động, bảo mật cao. Công nghệ: PHP 8.1+, MySQL, Tailwind CSS, PhpSpreadsheet, vanilla JS.

## Cấu trúc
- `public_html/` public frontend API/routes
- `admin/` admin entry
- `app/` core, controllers, services, config
- `app/migrations/schema.sql` schema DB
- `tests/` PHPUnit unit tests
- `docs/API.md` OpenAPI-like mô tả endpoint
- `deployment.md` hướng dẫn deploy Docker

## Thiết lập nhanh (local)
```bash
cp env.example .env   # điền biến môi trường
composer install
mysql -u root -p < app/migrations/schema.sql
php -S localhost:8000 -t public_html
```
Admin: tạo user và cập nhật role=admin + pin_hash = password_hash('123456', PASSWORD_DEFAULT).

## Environment
Các biến trong `env.example`: DB, MASTER_KEY, PAYMENT_SECRET, TELEGRAM, MAIL, GOOGLE OAUTH, RATE LIMIT.

## Tests
```bash
composer test
```

## Tính năng chính
- Mã hóa AES-256-GCM cho tài nguyên, chỉ giải mã khi giao hoặc admin nhập PIN.
- Checkout: giỏ hàng, áp mã giảm giá, thanh toán balance (PIN) hoặc gateway, auto-delivery variants và đổi trạng thái sold.
- Webhook thanh toán (order/recharge) + idempotency + anti-fraud cơ bản.
- Nhập Excel với mapping cột, lưu blob mã hóa; cảnh báo thiếu tồn kho khi giao.
- Affiliate bonus, discount, ticket, review, lucky-spin demo.
- Audit log + yêu cầu PIN cho hành động nhạy cảm (decrypt, adjust balance).

Chi tiết API và flow xem `docs/API.md` và `deployment.md`.

